{include file='file:core/header.tpl'}
<div class="app-main__inner">
	<div class="app-page-title app-page-title-simple">
		<div class="page-title-wrapper">
			<div class="page-title-heading">
				<div>
					<div class="page-title-head center-elem">
						<span class="d-inline-block pr-2">
							<i class="fas fa-user-edit opacity-6"></i>
						</span>
						<span class="d-inline-block">{$pagename}</span>
					</div>
					<div class="page-title-subheading opacity-10">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb">
								{foreach item=breadcrumb from=$breadcrumbs}
									{if $breadcrumb.url eq ""}
										<li class="breadcrumb-item active">{$breadcrumb.caption}</li>
									{else}
										<li class="breadcrumb-item"><a href="{$breadcrumb.url}">{$breadcrumb.caption}</a></li>
									{/if}
								{/foreach}
							</ol>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-md-8">
			<div class="main-card mb-3 card">
				{if count($usuarios) > 0}
					{foreach item=record from=$usuarios}
						<div class="card-header">Informações de #{$record.user}</div>
						{if count($error) > 0}
							<div class="alert alert-danger d-flex flex-row">
								<i class="fas fa-fw fa-times-circle mr-3 align-self-center"></i>
								<p class="mb-0">
									{foreach item=text from=$error}
										<li>{$text}</li>
									{/foreach}
								</p>
							</div>
						{/if}
						{if count($success) > 0}
							<div class="alert alert-success d-flex flex-row">
								<i class="fas fa-fw fa-check-circle mr-3 align-self-center"></i>
								<p class="mb-0">
									{foreach item=text from=$success}
										<li>{$text}</li>
									{/foreach}
								</p>
							</div>
						{/if}
						<div class="card-body">
							<table class="mb-0 table table-bordered">
								<tbody>
									<tr>
										<th scope="row">KEY</th>
										<td align="center">{$record.user}</td>
										<td width="20%" align="center"><a href="javascript:void(0);" onclick="copyUser('{$record.user}')">[Copiar]</a></td>
									</tr>
									<script>
										function copyUser(user) {
											var input = document.createElement('input');
											input.value = user;
											document.body.appendChild(input);
											input.select();
											document.execCommand('copy');
											document.body.removeChild(input);
											alert('Usuário copiado: ' + user);
										}
									</script>
									{if $auth.admin}
										<tr>
											<th scope="row">Cargo</th>
											<td align="center">{$record.cargo}</td>
											<td width="20%" align="center"><a href="{$script_url}?act=editar&name={$record.user}&sact=changecargo">[Mudar Cargo]</a></td>
										</tr>
									{/if}
									<tr>
										<th scope="row">Modo</th>
										<td align="center">
											{if $record.mode == 'injetorMobile'}<div class="badge badge-danger">Daemon</div>
											{elseif $record.mode == 'injetorEmulador'}<div class="badge badge-pill badge-dark">Emulador x86</div>
												{elseif $record.mode == 'externoemulador'}<div class="badge badge-pill badge-dark">External Emulador</div>
											{else}<div class="badge badge-pill badge-dark">MACRO</div>{/if}
										</td>
										<td width="20%" align="center"><a href="{$script_url}?act=editar&name={$record.user}&sact=changemode">[Mudar MODO]</a></td>
									</tr>
									<tr>
										<th scope="row">Status</th>
										<td align="center">
											{if $record.status != 1}
												{if strtotime(date("Y-m-d H:i:s")) <= strtotime($record.datafinal)}
													<div class='badge badge-pill badge-success'>Ativo</div>
												{elseif $record.datafinal == '0000-00-00 00:00:00'}
													<div class="badge badge-pill badge-secondary">Não Logado</div>
												{else}
													<div class="badge badge-pill badge-warning">Expirado</div> 
												{/if}
											{else}
												<div class='badge badge-pill badge-danger'>Banido</div>
											{/if}
										</td>
										{if $auth.admin}
											<td width="20%" align="center">
												{if $record.status == 0}<a href="{$script_url}?act=editar&name={$record.user}&banir=1">[BANIR]</a>
												{else}<a href="{$script_url}?act=editar&name={$record.user}&banir=2">[DESBANIR]</a>{/if}
											</td>
										{/if}
									</tr>
									<tr>
										<th scope="row">Pausar conta</th>
										<td align="center">
											{if $record.pause != 1}
												{if strtotime(date("Y-m-d H:i:s")) <= strtotime($record.datafinal)}
													<div class='badge badge-pill badge-success'>Ativo</div>
												{elseif $record.datafinal == '0000-00-00 00:00:00'}
													<div class="badge badge-pill badge-secondary">Não Logado</div>
												{else}
													<div class="badge badge-pill badge-warning">Expirado</div> 
												{/if}
											{else}
												<div class='badge badge-pill badge-danger'>Pausado</div>
											{/if}
										</td>
										
									  {if $record.cargo == 'cliente'}
                        <td width="20%" align="center">
                            {if $record.mode == 'injetorMobile' || $record.mode == 'injetorEmulador' || $record.mode == 'externoemulador'}
                                {if $record.segundos >= 1 || $record.pause == 1}
                                    {if $record.pause == 0}
                                    	{if $auth.admin}
                                        <a href="{$script_url}?act=editar&name={$record.user}&pause=1">[PAUSAR]</a>
                                        	{/if}
                                    {else}
                                        <a href="{$script_url}?act=editar&name={$record.user}&pause=2">[RETOMAR]</a>
                                    {/if}
                                    
                                {/if}
                            {/if}
                        </td>
                    {/if}

					</tr>
					</tbody>
				</table>
				</div>
					{/foreach}
				{/if}
			</div>
			{if $auth.admin}
				<div class="main-card mb-3 card">
					<div class="card-header">Editar Tempo do Membro</div>
					<div class="card-body">
						<form action="" method="POST">
							<div class="position-relative row form-group">
								<label for="exampleEmail" class="col-sm-2 col-form-label">Tempo do Membro</label>
								<div class="col-sm-10">
									<input size="2" type="number" min="0" placeholder="Quantidade de dias" name="endate" class="form-control">
								</div>
							</div>
							<div class="d-block text-right card-footer">
								<button type="submit" name="adddias" class="btn btn-primary btn-lg">ADICIONAR DIAS</button>
								<button type="submit" name="deldias" class="btn btn-danger btn-lg">REMOVER DIAS</button>
							</div>
						</form>
					</div>
				</div>
			{/if}
		</div>
		<div class="col-md-4">
			<div class="main-card mb-3 card">
				<div class="card-header">Informações Adicionais</div>
				<div class="card-body p-0">
					{$NewPanel}
				</div>
			</div>
		</div>
	</div>
</div>
{include file='file:core/footer.tpl'}
