{include file='file:core/header.tpl'}
<div class="app-main__inner">
    <div class="app-page-title app-page-title-simple">
        <div class="page-title-wrapper">
            <div class="page-title-heading">
                <div>
                    <div class="page-title-head center-elem">
                        <span class="d-inline-block pr-2">
                            <i class="fas fa-user-plus opacity-6"></i>
                        </span>
                        <span class="d-inline-block">{$pagename}</span>
                    </div>
                    <div class="page-title-subheading opacity-10">
                        <nav class="" aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                {foreach item=breadcrumb from=$breadcrumbs}
                                    {if $breadcrumb.url eq ""}
                                        <li class="breadcrumb-item active"><a>{$breadcrumb.caption}</a></li>
                                    {else}
                                        <li class="breadcrumb-item"><a href="{$breadcrumb.url}">{$breadcrumb.caption}</a></li>
                                    {/if}
                                {/foreach}
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="main-card mb-3 card">
                <div class="card-header">Adicionar Key</div>
                <div class="card-body">
                    {if count($error) > 0}
                        <center>
                            <div class="alert alert-danger" role="alert">
                                <p class="mb-0">
                                    {foreach item=text from=$error}
                                        <li>{$text}</li>
                                    {/foreach}
                                </p>
                            </div>
                        </center>
                    {/if}
                    {if count($success) > 0}
                        <center>
                            <div id="successMessage" class="alert alert-success d-flex flex-row">
                                <i class="fas fa-fw fa-check-circle mr-3 align-self-center"></i>
                                <p id="successText" class="mb-0">
                                    {foreach item=text from=$success}
                                        {$text}
                                    {/foreach}
                                </p>
                            </div>
                            <div class="text-center">
                                <button id="copySuccess" class="btn btn-primary">Copiar Mensagem de Sucesso</button>
                            </div>
                        </center>
                    {/if}
            
                    <div class="text-center">
                        <form action="{$base_url}index.php?act=adduser" method="POST">
                            <input type="hidden" name="newuser_form" />
                            
                            <div class="position-relative row form-group">
                                <label for="modeSelect" class="col-sm-2 col-form-label">Modo</label>
                                <div class="col-sm-10">
                                    <select name="modo" id="modeSelect" class="form-control" required>
                                        <option value="">Selecione o modo</option>
                                        {foreach from=$versoes_select item=versao}
                                        <option value="{$versao}">{$versao}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div class="position-relative row form-group">
                                <label for="diasSelect" class="col-sm-2 col-form-label">Dias</label>
                                <div class="col-sm-10">
                                    <select name="dias" id="diasSelect" class="form-control" required>
                                        <option value="">Selecione a validade</option>
                                        <option value="5">5 Dias</option>
                                        <option value="10">10 Dias</option>
                                        <option value="30">1 Mês</option>
                                    </select>
                                </div>
                            </div>

                            <div class="position-relative row form-group">
                                <label for="deviceSelect" class="col-sm-2 col-form-label">Device</label>
                                <div class="col-sm-10">
                                    <select name="device" id="deviceSelect" class="form-control" required>
                                        <option value="">Selecione</option>
                                        <option value="1">1 Device</option>
                                        {if !$auth.seller}
                                            <option value="2">2 Devices</option>
                                            <option value="ilimitado">Ilimitado</option>
                                        {/if}
                                    </select>
                                </div>
                            </div>

                            <div class="d-block text-right card-footer">
                                <button type="submit" name="Submit" class="btn btn-dark btn-lg">Gerar Key</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('copySuccess').addEventListener('click', function() {
        var successMessage = document.getElementById('successText').innerText;
        navigator.clipboard.writeText(successMessage);
        alert('Mensagem copiada: ' + successMessage);
    });
</script>

{include file='file:core/footer.tpl'}