{include file='file:core/header.tpl'}


<div class="app-main__inner">
<div class="app-page-title app-page-title-simple">
	<div class="page-title-wrapper">
		<div class="page-title-heading">
			<div>
			<div class="page-title-head center-elem">
				<span class="d-inline-block pr-2">
					<i class="fas fa-building opacity-6"></i>
				</span>
				<span class="d-inline-block">{$pagename}</span>
			</div>
			<div class="page-title-subheading opacity-10">
				<nav class="" aria-label="breadcrumb">
					<ol class="breadcrumb">
						{foreach item=breadcrumb from=$breadcrumbs}
							{if $breadcrumb.url eq ""}
									<li class="breadcrumb-item active"><a>{$breadcrumb.caption}</a></li>
							{else}
									<li class="breadcrumb-item"><a href="{$breadcrumb.url}">{$breadcrumb.caption}</a></li>
							{/if}
						{/foreach}
					</ol>
				</nav>
			</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-lg-6 col-xl-4">
		<div class="card mb-3 widget-content bg-premium-dark">
			<div class="widget-content-wrapper text-white">
				<div class="widget-content-left">
					<div class="widget-heading">Usuários Ativos</div>
					<div class="widget-subheading">Total de clientes Ativos</div>
				</div>
				<div class="widget-content-right">
					<div class="widget-numbers text-warning"><span>{$account.validos}</span></div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-6 col-xl-4">
		<div class="card mb-3 widget-content bg-premium-dark">
			<div class="widget-content-wrapper text-white">
				<div class="widget-content-left">
					<div class="widget-heading">Usuários Não Ativados</div>
					<div class="widget-subheading">Total de clientes Não Ativados</div>
				</div>
				<div class="widget-content-right">
					<div class="widget-numbers text-warning"><span>{$account.expirados}</span></div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row equal-height">
    <!-- Pagamento via Binance -->
    <div class="col-lg-6 col-xl-6">
        <div class="card mb-3 widget-content bg-premium-dark card-equal">
            <div class="widget-content-wrapper text-white">
                <div class="widget-content-left">
                    <div class="widget-heading">DOWNLOAD CHEAT</div>
                 <div class="widget-subheading">Baixe os Apks Aqui .</div>
                </div>
                <div class="widget-content-right">
                    <!-- Botão de pagamento -->
                     <!-- <a class="btn btn-primary" href="https://lkteamloja.xyz/Downloads/" target="_blank">
                        Baixar-->
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Redirecionamento para o Discord -->
    <div class="col-lg-6 col-xl-6">
        <div class="card mb-3 widget-content bg-premium-dark card-equal">
            <div class="widget-content-wrapper text-white">
                <div class="widget-content-left">
                    <div class="widget-heading">IGRH4X</div>
                    <div class="widget-subheading">Entre em contato no nosso Discord .</div>
                </div>
                <div class="widget-content-right">
                    <a class="btn btn-primary" href="" target="_blank">
                        Entrar no Discord
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
	
	<div class="row">
		<div class="col-md-8">
			<div class="main-card mb-3 card">
				<div class="card-header">Últimos usuários
				</div>
				<div class="card-body p-0">
		
					<div class="table-responsive">
					<table class="mb-0 table table-striped table-hover">
						<thead align="center" class="thead-dark">
							<tr>
								<th>Usuário</th>
								<th>Vendedor</th>
								<th>Data</th>
								<th>Tipo</th>
							</tr>
						</thead>
						<tbody align="center">
                           <tbody align="center">
                                    {if count($lastsell) > 0}
                                        {foreach item=last from=$lastsell}
                                            {if strpos($last.user, "APKTESTE-") === 0}
                                                {assign var="partialName" value="APKTESTE-"|cat:$last.user|substr:9}
                                                {assign var="hiddenPart" value=str_repeat("*", max(strlen($last.user) - 9, 0))}
                                                <tr>
                                                    <td style="text-transform: capitalize;">APKTESTE-{$hiddenPart}</td>
                                                    <td style="text-transform: capitalize;">{$last.vendedor}</td>
                                                    <td>{$last.data}</td>
                                                    <td>{if $last.modo == 'injetorMobile'}<div class="badge badge-danger">Daemon</div>
                                                    {elseif $last.modo == 'injetorEmulador'}<div class="badge badge-pill badge-dark">Emulador x86</div>
                                                     {elseif $last.modo == 'externoemulador'}<div class="badge badge-pill badge-dark">External Emulador</div>
                                                    {else}<div class="badge badge-pill badge-dark">MACRO33</div>{/if}</td>
                                                </tr>
                                            {else}
                                                {assign var="partialName" value="IGRH4X-"|cat:$last.user|substr:7}
                                                {assign var="hiddenPart" value=str_repeat("*", max(strlen($last.user) - 7, 0))}
                                                <tr>
                                                    <td style="text-transform: capitalize;">IGRH4X-{$hiddenPart}</td>
                                                    <td style="text-transform: capitalize;">{$last.vendedor}</td>
                                                    <td>{$last.data}</td>
                                                    <td>{if $last.modo == 'injetorMobile'}<div class="badge badge-danger">Daemon</div>
                                                    {elseif $last.modo == 'injetorEmulador'}<div class="badge badge-pill badge-dark">Emulador x86</div>
                                                      {elseif $last.modo == 'externoemulador'}<div class="badge badge-pill badge-dark">External Emulador</div>
                                                    {else}<div class="badge badge-pill badge-dark">MACRO33</div>{/if}</td>
                                                </tr>
                                            {/if}
                                        {/foreach}
                                    {/if}
                                </tbody>

					</table>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-4">
			<div class="main-card mb-3 card">
				<div class="card-header"> <b><i class="fas fa-trophy"></i></b> &nbsp;&nbsp;Melhor Vendedor</center>
				</div>
				<div class="card-body p-0">
					<div class="table-responsive">
						<table class="mb-0 table table-striped table-hover">
							<thead align="center" class="thead-dark">
								<tr>
									<th>Rank</th>
									<th>Usuário</th>
									<th>Vendas</th>
								</tr>
							</thead>
							<tbody align="center">
								{if count($rank) > 0}
								{foreach item=ranks from=$rank}
								<tr>
									{if $ranks.rank == 1}
									<td><span style="display: inline-block;width:20px!important;height:20px!important;border-radius:50%!important;" class="bg-sunny-morning"><i style="color:#FFCD00!important;" class="fas fa-medal"></i></span></td>
									{elseif $ranks.rank == 2}
									<td><span style="display: inline-block;width:20px!important;height:20px!important;border-radius:50%!important;" class="bg-secondary"><i style="color:#DADADA!important;" class="fas fa-medal"></i></span></td>
									{elseif $ranks.rank == 3}
									<td><span style="display: inline-block;width:20px!important;height:20px!important;border-radius:50%!important;" class="bg-strong-bliss"><i style="color:#DEC2C2!important;" class="fas fa-medal"></i></span></td>
									{else}
									<td><span style="display: inline-block;width:20px!important;height:20px!important;border-radius:50%!important;" class="bg-heavy-rain"> <b style="color:#545454">{$ranks.rank}</b></span></td>
									{/if}
									<td><b style="text-transform: uppercase;">{$ranks.user}</b></td>
									<td><span class="ml-2 badge badge-pill badge-dark">{$ranks.vendas}</span></td>
									
								</tr>
								{/foreach}
								{/if}
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>		
	</div>
</div>
{include file='file:core/footer.tpl'}
