<?php

if(!defined('lightengine'))
{
	die('What are you doing here?');
}

elseif (!$auth->getLoggedIn())
{
	header('location: index.php?act=login');
	return;
}


if (!$auth->getIsAdmin()&& !$auth->getIsMod())
{
	header('location: index.php?act=login');
}

require_once(BASE_PATH . 'class' . DIRECTORY_SEPARATOR . 'class.smtpmailer.php');


$error = array();
$success = array();

$sent = isset($_POST['form']);

if (isset($_POST['form']))
{
	
	$login = POST_String('login');

	
	$password = POST_String('password');

	
	$repassword = POST_String('repassword');

	
	$key = "";
	$salt = "";
	$Personalization = "";
	$blake2s = new BLAKE2s($key, $salt, $Personalization);	
	
	$credits = POST_String('credits');
	
	$a_level = POST_String('a_level');

	
	if (empty($login))
	{
		$error[] = 'Você não digitou o usuário!';
	}
	else
	{
		$length = strlen($login);
		if ($length < 4 || $length > 15)
		{
			$error[] = 'O comprimento do usuário deve ser de 5 a 15 caracteres!';
		}
		else
		{
			if (!preg_match('|^[A-Z0-9]+$|i', $login))
			{
				$error[] = 'Você digitou um usuário inválido! Use apenas números e letras!';
			}
		}
	}

	if (empty($password))
	{
		$error[] = 'Você não digitou a senha!';
	}
	else
	{
		$length = strlen($password);
		if ($length < 4 || $length > 15)
		{
			$error[] = 'O comprimento da senha deve ser de 4 a 15 caracteres!';
		}
		else
		{
			if (!preg_match('|^[A-Z0-9]+$|i', $password))
			{
				$error[] = 'Você digitou uma senha incorreta! Use apenas números e letras!';
			}
		}
	}

	if (empty($repassword))
	{
		$error[] = 'Você não digitou a confirmação da senha!';
	}
	else
	{
		if (strcmp($repassword, $password) !== 0)
		{
			$error[] = 'As senhas inseridas não são iguais!';
		}
	}

    if (empty($a_level))
	{
		$error[] = 'Você não definiu O Cargo';
	}
	
	if (count($error) == 0)
	{
		$dbh = $game_db->prepare('SELECT COUNT(id) as counter FROM account_login WHERE name=?');
		$dbh->bindParam(1, $login);
		$dbh->execute();
		$row = $dbh->fetchObject();

		if ($row->counter > 0)
		{
			$error[] = 'A conta <strong>' . $login . '</strong> já existe!';
		} else {


            $success[] = 'Usuário Registrado';
        }
    }

	if (count($error) == 0)
	{		
		$hashed_password = $blake2s->hash($password);
		
		$ip = $_SERVER['REMOTE_ADDR'];
		
		$dbh = $game_db->prepare('INSERT INTO account_login (name, originalPassword, password, credits, a_level) VALUES (?,?,UPPER(?),?,?)');
		$dbh->bindParam(1, $login);
		$dbh->bindParam(2, $password);
		$dbh->bindParam(3, $hashed_password);
		$dbh->bindParam(4, $credits);
		$dbh->bindParam(5, $a_level);
		$dbh->execute();
		
		if ($config['registration']['activation'])
		{
		
			$dbh = $game_db->prepare('UPDATE account_login SET ban=1 WHERE name=?');
			$dbh->bindParam(1, $login);
			$dbh->execute();

			$hash = md5($login);

			$time = time();

			$dbh1 = $light_db->prepare('INSERT INTO activation (account, a_level, hash, time, ip) VALUES (?,?,?,?,?)');
			$dbh1->bindParam(1, $login);
			$dbh1->bindParam(2, $a_level);
			$dbh1->bindParam(3, $hash);
			$dbh1->bindParam(4, $time);
			$dbh1->bindParam(5, $ip);
			$dbh1->execute();
			
			$smarty->assign('login', $login);
			$smarty->assign('hash', $hash);

			$mail = new CSmtpMailer();
			$mail->setHost($config['smtp']['host'], $config['smtp']['port']);
			$mail->setUser($config['smtp']['login'], $config['smtp']['password']);
			$mail->setFromName($config['server_name']);
			$mail->setSubject($config['server_name'].' - Registro de conta');
			$mail->setBody($smarty->fetch('email/register.tpl'));
			$mail->addAddress($email);
			$mail->Send();
		}
	}
	$smarty->assign('login', $login);
}

$breadcrumbs = array(
	array('url' => 'index.php', 'caption' => 'Dashboard'),
	array('url' => 'index.php?act=admin', 'caption' => 'Administração'),
	array('url' => '', 'caption' => 'Adicionar vendedor'),
);

$smarty->assign('pagename', 'Adicionar vendedor');
$smarty->assign('breadcrumbs', $breadcrumbs);
$smarty->assign('active', 'register');
$smarty->assign('error', $error);
$smarty->assign('success', $success);
$smarty->assign('sent', $sent);
$smarty->assign('recaptcha_key', $config['recaptcha']['public_key']);
$smarty->assign('activation', $config['registration']['activation']);
$smarty->display('pages/register.tpl');

?>