<?php

/*

	File: inc.admin.php
	Author: Wantows
	Date: 06/05/2021
*/

if(!defined('lightengine'))
{
	die('What are you doing here?');
}

if (!$auth->getLoggedIn())
{
	header('location: index.php?act=login');
	return;
}

if (!$auth->getIsAdmin())
{
	header('location: index.php?act=404');
	return;
}

$error = array();
$success = array();



// Função para calcular o tempo devolvido
function DevolverTempo($data_pausada, $data_expiracao) {
    $timestamp_dt_atual = strtotime(date("Y-m-d H:i:s")); 
    $timestamp_dt_pausada = strtotime($data_pausada);
    $timestamp_dt_expiracao = strtotime($data_expiracao);
    
    // Calcula a diferença
    $tempo_pausado = $timestamp_dt_atual - $timestamp_dt_pausada;
    if ($tempo_pausado > 0) {
        $dias = floor($tempo_pausado / 86400);
        $horas = floor(($tempo_pausado % 86400) / 3600);
        $minutos = floor(($tempo_pausado % 3600) / 60);
        $segundos = $tempo_pausado % 60;
        
        return ['dias' => $dias, 'horas' => $horas, 'minutos' => $minutos, 'segundos' => $segundos];
    } else {
        return ['dias' => 0, 'horas' => 0, 'minutos' => 0, 'segundos' => 0];
    }
}

// PAUSAR CONTA
if (isset($_POST['pauselkteam'])) {
    $versao = POST_String('modo');
    $pais = POST_String('pais'); // Captura o país selecionado no formulário

    if (empty($versao)) {
        $error[] = 'Você não escolheu uma versão. ' . $versao;
    } elseif ($versao != 'injetorMobile' && $versao != 'injetorEmulador' && $versao != 'externoemulador') {
        $error[] = 'Você não escolheu uma versão existente.';
    } else {
        $dateHoje = date("Y-m-d H:i:s");

        // Ajusta a consulta de acordo com o país selecionado
        if ($pais == 'brazil') {
            // Seleciona apenas logins do Brasil que não estão expirados
            $sql = $game_db->query("SELECT * FROM tokens WHERE mode = '".$versao."' AND EndDate > '$dateHoje' AND StartDate != '0000-00-00 00:00:00' AND PaisLogin = 'brazil'");
        } else {
            // Seleciona logins de todos os países, exceto Brasil, que não estão expirados
            $sql = $game_db->query("SELECT * FROM tokens WHERE mode = '".$versao."' AND EndDate > '$dateHoje' AND StartDate != '0000-00-00 00:00:00' AND PaisLogin != 'brazil'");
        }

        // Verifique se há usuários a serem pausados
        if ($sql->rowCount() > 0) {
            while ($rows = $sql->fetchObject()) {
                $dbh = $game_db->prepare("UPDATE tokens SET pause = '1', pausedate=? WHERE id = ?");
                $dbh->bindParam(1, $dateHoje);
                $dbh->bindParam(2, $rows->id);
                if ($dbh->execute()) {
                    $dateLog = date("Y-m-d H:i:s");
                    $auth->Admin_AddLog("PAUSOU LOGINS: ".$rows->Username, $auth->getLogin(), "Todos ".$versao, $dateLog, "PAUSADOS");
                }
            }

            // Mensagem de sucesso simples
            $success[] = 'Todos os logins foram pausados com sucesso.';
        } else {
            $error[] = 'Nenhum usuário encontrado para pausar com esta versão e país.';
        }
    }
}



// Buscar versões cadastradas para usar nos selects
$versoes_select = array();
$sql = $game_db->query('SELECT * FROM versoes ORDER BY id DESC');
while ($row = $sql->fetchObject()) {
    $versoes_select[] = $row->versao;
}

$smarty->assign('versoes_select', $versoes_select);




if (isset($_POST['form_dias'])) {
    try {
        $versao = POST_String('modo');
        
        if(empty($versao)) {
            throw new Exception('Você não escolheu uma versão.');
        }

        // Verifica se a versão existe na tabela versoes
        $check_versao = $game_db->prepare("SELECT COUNT(*) FROM versoes WHERE versao = ?");
        if(!$check_versao) {
            throw new Exception('Erro ao preparar consulta de versões: ' . $game_db->errorInfo()[2]);
        }
        
        $check_versao->bindParam(1, $versao);
        if(!$check_versao->execute()) {
            throw new Exception('Erro ao executar consulta de versões: ' . $check_versao->errorInfo()[2]);
        }
        
        $versao_existe = $check_versao->fetchColumn();
        if($versao_existe == 0) {
            throw new Exception('Versão não encontrada no banco de dados.');
        }

        $endate = POST_Integer('endate');
        if($endate < 1 || $endate > 90) {
            throw new Exception('Quantidade de dias deve ser entre 1 e 90.');
        }

        $dateHJ = date("Y-m-d H:i:s");
        $Contar = 0;
        $TemDias = 0;

        // Busca usuários com a versão selecionada
        $sql = $game_db->prepare("SELECT id, Username, EndDate FROM tokens WHERE mode = ? AND pause = 0");
        if(!$sql) {
            throw new Exception('Erro ao preparar consulta de tokens: ' . $game_db->errorInfo()[2]);
        }
        
        $sql->bindParam(1, $versao);
        if(!$sql->execute()) {
            throw new Exception('Erro ao executar consulta de tokens: ' . $sql->errorInfo()[2]);
        }

        // Processa cada usuário
        while ($rows = $sql->fetchObject()) {
            $Contar++;
            
            $dt_expira = date("Y-m-d H:i:s", strtotime("+{$endate} days", strtotime($rows->EndDate)));
            
            $update = $game_db->prepare("UPDATE tokens SET EndDate = ? WHERE id = ?");
            if(!$update) {
                throw new Exception('Erro ao preparar atualização: ' . $game_db->errorInfo()[2]);
            }
            
            $update->bindParam(1, $dt_expira);
            $update->bindParam(2, $rows->id);
            
            if($update->execute()) {
                $TemDias++;
            } else {
                error_log("Erro ao atualizar usuário ID {$rows->id}: " . $update->errorInfo()[2]);
            }
        }

        // Log e mensagem de sucesso
        $dateLog = date("Y-m-d H:i:s");
        $auth->Admin_AddLog("Adicionou dias para Todos ".$versao, $auth->getLogin(), "Todos ".$versao, $dateLog, "Quantidade: ".$endate);
        
        $success[] = "Foram adicionados {$endate} dias para {$TemDias} usuários (de {$Contar} encontrados).";
        header('refresh:5;url=index.php?act=admin');

    } catch (Exception $e) {
        $error[] = 'Erro: ' . $e->getMessage();
        error_log('Admin Error: ' . $e->getMessage());
    }
}

// DESPAUSAR CONTA
if (isset($_POST['despauselkteam'])) {
    $versao = POST_String('modo');
    $pais = POST_String('pais'); // Captura o país selecionado no formulário

    if (empty($versao)) {
        $error[] = 'Você não escolheu uma versão. ' . $versao;
    } elseif ($versao != 'injetorMobile' && $versao != 'injetorEmulador' && $versao != 'externoemulador') {
        $error[] = 'Você não escolheu uma versão existente.';
    } else {
        $dateHoje = date("Y-m-d H:i:s");

        // Ajusta a consulta de acordo com o país selecionado
        if ($pais == 'brazil') {
            // Seleciona apenas logins do Brasil que estão pausados
            $sql = $game_db->query("SELECT * FROM tokens WHERE mode = '".$versao."' AND pause = '1' AND PaisLogin = 'brazil'");
        } else {
            // Seleciona logins de todos os países, exceto Brasil, que estão pausados
            $sql = $game_db->query("SELECT * FROM tokens WHERE mode = '".$versao."' AND pause = '1' AND PaisLogin != 'brazil'");
        }

        // Verifica se existem logins pausados
        if ($sql->rowCount() > 0) {
            $tempoTotalDevolvido = [
                'dias' => 0,
                'horas' => 0,
                'minutos' => 0,
                'segundos' => 0,
            ];

            while ($rows = $sql->fetchObject()) {
                $tempoDevolvido = DevolverTempo($rows->pausedate, $rows->EndDate);
                
                // Atualiza o tempo total devolvido
                $tempoTotalDevolvido['dias'] += $tempoDevolvido['dias'];
                $tempoTotalDevolvido['horas'] += $tempoDevolvido['horas'];
                $tempoTotalDevolvido['minutos'] += $tempoDevolvido['minutos'];
                $tempoTotalDevolvido['segundos'] += $tempoDevolvido['segundos'];

                // Calcula a nova data de expiração com base no tempo devolvido
                $dt_expira = date("Y-m-d H:i:s", strtotime('+' . $tempoDevolvido['dias'] . ' days + ' . $tempoDevolvido['horas'] . ' hours + ' . $tempoDevolvido['minutos'] . ' minutes + ' . $tempoDevolvido['segundos'] . ' seconds', strtotime($rows->EndDate)));

                // Atualiza o banco de dados para remover o pause e ajustar a nova data de expiração
                $dbh = $game_db->prepare("UPDATE tokens SET EndDate = ?, pause = '0', pausedate = NULL WHERE id = ?");
                $dbh->bindParam(1, $dt_expira);
                $dbh->bindParam(2, $rows->id);
                $dbh->execute(); // Executa a atualização sem precisar de verificação de sucesso
            }

            // Adiciona log com o tempo total devolvido
            $logMessage = sprintf("Devolveu %d dias, %d horas, %d minutos e %d segundos", 
                $tempoTotalDevolvido['dias'], 
                $tempoTotalDevolvido['horas'], 
                $tempoTotalDevolvido['minutos'], 
                $tempoTotalDevolvido['segundos']);
            $auth->Admin_AddLog("Despausou LOGINS: ", $auth->getLogin(), "Todos ".$versao, $dateHoje, $logMessage);
            $success[] = 'Todos os logins foram despausados com sucesso. Tempo devolvido total: ' . $logMessage;
        } else {
            $error[] = 'Nenhum login encontrado para despausar com esta versão e país.';
        }
    }
}

if (isset($_POST['form_dias2']))
{

	$versao = POST_String('modo');

	if(empty($versao)){
		$error[] ='Você não escolheu uma versão. '.$versao;
	}elseif($versao != 'injetorMobile' && $versao != 'injetorEmulador' && $versao != 'externoemulador'){
		$error[] ='Você não escolheu uma versão existente.';
	}else{
		
		$Contar;
			$TemDias;

			$sql = $game_db->query("SELECT * FROM tokens WHERE mode ='".$versao."' AND pause = 0 ");
			while ($rows = $sql->fetchObject())
			{
				$Contar++;

				$dt_atual = date("Y-m-d H:i:s"); // data atual
				$timestamp_dt_atual = strtotime($dt_atual); // converte para timestamp Unix
				 
				$dt_expira = date("Y-m-d H:i:s", strtotime(date('Y-m-d H:i:s', strtotime($rows->EndDate))));
				
				$timestamp_dt_expira = strtotime($dt_expira); // converte para timestamp Unix
			    $data_inicio = new DateTime($dt_atual);
			    $data_fim = new DateTime($dt_expira);
			    
			    // Resgata diferença entre as datas
			    $dateInterval = $data_inicio->diff($data_fim);

			    if($timestamp_dt_atual > $timestamp_dt_expira ){
			         if($timestamp_dt_expira > '0000-00-00 00:00:00' ){
			    	$TemDias++;

					$rst1 = $game_db->prepare("DELETE FROM tokens WHERE id=?");
		            $rst1->bindParam(1, $rows->id);
		            if(!$rst1->execute()){
		            	$error[] = 'Ocorreu um erro ao deletar o login '.$rows->Username.'.';
		            }else{
		            		$auth->Admin_AddLog("removeu : ".$rows->Username, $auth->getLogin(), "Todos ".$versao, $dt_atual,"EXPIRADOS");
		            }
			         }
			    }

			}

          
			$dateLog = date("Y-m-d H:i:s");
		    if($TemDias > 0){
                $success[] = 'Voçe deletou '.$TemDias.' clientes  Expirados ';
		    }else{
		    	$error[] = 'Nenhum login para ser deletado no  '.$versao.'.';
		    }
			header('refresh:5;url=index.php?act=admin');
	}
}



$restore_accounts = array();
$query = $light_db->query('SELECT account, time, email FROM restore ORDER BY time DESC');
while ($row = $query->fetchObject())
{
	$restore_accounts[] = array(
		'login' => $row->account,
		'email' => $row->email,
		'time' => date('H:i:s m/d/Y', $row->time),
	);
}


if ($config['registration']['activation'] == true)
{
	$pending_accounts = array();
	$query = $light_db->query('SELECT account, time, email, hash FROM activation ORDER BY time DESC');
	while ($row = $query->fetchObject())
	{
		$pending_accounts[] = array(
			'login' => $row->account,
			'email' => $row->email,
			'time' => date('H:i:s m/d/Y', $row->time),
			'hash' => $row->hash,
		);
	}
	
	$smarty->assign('pending_accounts', $pending_accounts);
}

$cheats = array();
$sql = $game_db->query('SELECT * FROM products');
while ($rows = $sql->fetchObject())
{
	$cheats[] = array(
		'id' => $rows->id,
		'img' => $rows->img,
		'gamename' => $rows->gamename,
		'version' => $rows->version,
		'mode' => $rows->mode,
		'update' => $rows->last_update,
		'status' => $rows->status,
		'size' => $rows->apk_size,
	);
}



// Adicionar versão
if (isset($_POST['form_versao'])) {
    $versao = POST_String('versao');
    
    if(empty($versao)) {
        $error[] = 'Por favor, digite uma versão.';
    } else {
        $dbh = $game_db->prepare("INSERT INTO versoes (versao) VALUES (?)");
        $dbh->bindParam(1, $versao);
        
        if($dbh->execute()) {
            $success[] = 'Versão adicionada com sucesso!';
            $dateLog = date("Y-m-d H:i:s");
            $auth->Admin_AddLog("Adicionou versão: ".$versao, $auth->getLogin(), "Admin", $dateLog, "Nova versão");
        } else {
            $error[] = 'Erro ao adicionar versão.';
        }
    }
}

// Excluir versão
if (isset($_POST['delete_versao'])) {
    $id = POST_Integer('delete_versao');
    
    $dbh = $game_db->prepare("DELETE FROM versoes WHERE id = ?");
    $dbh->bindParam(1, $id);
    
    if($dbh->execute()) {
        $success[] = 'Versão excluída com sucesso!';
        $dateLog = date("Y-m-d H:i:s");
        $auth->Admin_AddLog("Excluiu versão ID: ".$id, $auth->getLogin(), "Admin", $dateLog, "Exclusão de versão");
    } else {
        $error[] = 'Erro ao excluir versão.';
    }
}

// Buscar versões cadastradas
$versoes = array();
$sql = $game_db->query('SELECT * FROM versoes ORDER BY id DESC');
while ($row = $sql->fetchObject()) {
    $versoes[] = array(
        'id' => $row->id,
        'versao' => $row->versao
    );
}

$smarty->assign('versoes', $versoes);




$breadcrumbs = array(
	array('url' => 'index.php?act=account', 'caption' => 'Dashboard'),
	array('url' => '', 'caption' => 'Administração'),
);


$smarty->assign('pagename', 'Administração');
$smarty->assign('breadcrumbs', $breadcrumbs);
$smarty->assign('active', 'admin');
$smarty->assign('cheats', $cheats);
$smarty->assign('restore_accounts', $restore_accounts);
$smarty->assign('error', $error);
$smarty->assign('success', $success);
$smarty->assign('date', date("Y-m-d H:i:s"));
$smarty->assign('activation_enabled', $config['registration']['activation']);
$smarty->display('pages/admin/admin.tpl');
?>