<?php

/*
	
	File: inc.editar.php
	Author: Wantows
	Date: 17.05.2021
*/

if(!defined('lightengine'))
{
	die('What are you doing here?');
}

if (!$auth->getLoggedIn())
{
	header('location: index.php?act=login');
	return;
}

$UserEdit = GET_String('name');


function DevolverTempo($data_pausada) {
    $data_expira = date("Y-m-d H:i:s"); 
    $timestamp_dt_atual = strtotime($data_pausada);
    $timestamp_dt_expira = strtotime($data_expira);
    
    // Resgata diferença entre as datas
    $data_inicio = new DateTime($data_pausada);
    $data_fim = new DateTime($data_expira);
    $dateInterval = $data_inicio->diff($data_fim);

    return [
        'dias' => $dateInterval->days,
        'horas' => $dateInterval->h,
        'minutos' => $dateInterval->i,
        'segundos' => $dateInterval->s
    ]; 
}


function ChangeName($Account)
{
	$Template = '';
	
	$Template.= '<center><form action="index.php?act=editar">';
	$Template.= '<input type="hidden" name="act" value="editar" />';
	$Template.= '<input type="hidden" name="name" value="'.$Account.'" />';
	$Template.= '<label><b>Nome atual:</b></label><input type="text" style="width:200px" class="form-control" value="'.$Account.'" readonly/>';
	$Template.= '<label><b>Novo nome:</b></label><input type="text" style="width:200px" class="form-control" name="change" />';
	$Template.= '<br><input type="submit" style="cursor:pointer" class="btn btn-success" value="Mudar nome"   />';
	$Template.= '</form></center><br />';
		
	return $Template;
}



function ChangeCargo($Account)
{
	$Template = '';
	
	$Template.= '<center><form action="index.php?act=editar">';
	$Template.= '<input type="hidden" name="act" value="editar" />';
	$Template.= '<input type="hidden" name="name" value="'.$Account.'" />';
	$Template.= '<label><b>Novo cargo:</b></label><input type="text" style="width:200px" class="form-control" name="changecargo" />';
	$Template.= '<br><input type="submit" style="cursor:pointer" class="btn btn-success" value="Mudar cargo"   />';
	$Template.= '</form></center><br />';
		
	return $Template;
}

function ChangeMode($Account, $Mode)
{
	
	$Template = '';
	$Template.= '<center><form action="index.php?act=editar">';
	$Template.= '<input type="hidden" name="act" value="editar" />';
	$Template.= '<input type="hidden" name="name" value="'.$Account.'" />';
	$Template.= '<label><b>Selecionar novo modo:</b></label>';
	$Template.= '<select style="width:200px" name="changemodo" class="form-control">';
	if($Mode == 'injetorEmulador'){
		$Template.= '<option value="injetorEmulador">Emulador x86</option>';
		//$Template.= '<option value="injetorMobile">Mobile</option>';
	
	}elseif($Mode == 'injetorMobile'){
		$Template.= '<option value="injetorMobile">Mobile</option>';
		//$Template.= '<option value="injetorEmulador">Emulador x86</option>';
	
	}
	elseif($Mode == 'externoemulador'){
		$Template.= '<option value="externoemulador">External Emulador</option>';
	
	
	}
	$Template.= '</select>';
	$Template.= '<br><input type="submit" style="cursor:pointer" class="btn btn-success" value="Mudar modo"   />';
	$Template.= '</form></center><br />';
		
	return $Template;

}

$usuarios = array();
$error = array();
$success = array();
$selectBool = false;
$selectBool2 = false;
$selectBoolF = false;

$count = 0;

if($auth->getIsAdmin()){
	$rst = $game_db->prepare("SELECT COUNT(id) as number FROM tokens WHERE Username=?");
	$rst->bindParam(1, $UserEdit);
	$rst->execute();
	$count = $rst->fetchObject()->number;
}else{
	$rst = $game_db->prepare("SELECT COUNT(id) as number FROM tokens WHERE Username=? AND Vendedor = ?");
	$rst->bindParam(1, $UserEdit);
	$rst->bindParam(2, $auth->getLogin());
	$rst->execute();
	$count = $rst->fetchObject()->number;
}

if ($count < 1)
{
	header('location: index.php?act=users');
	return;
}else{
	
	$dbh = $game_db->prepare('SELECT * FROM tokens WHERE Username = ? AND Vendedor=?');
	$dbh->bindParam(1, $UserEdit);
	$dbh->bindParam(2, $auth->getLogin());

	if($auth->getIsAdmin()){
		$dbh = $game_db->prepare('SELECT * FROM tokens WHERE Username=?');
		$dbh->bindParam(1, $UserEdit);
	}

	$dbh->execute();
	
	$Mod = '';
	$UserData;
	$PauseData;
	while ($row = $dbh->fetchObject())
	{
		
		if($row->UID2 == 'one device') {
			if($row->UID == NULL){
				$uid = '0/1'; 
			}else{
				$uid = '1/1';
			}
		}else {
			if($row->UID == NULL AND $row->UID2 == NULL){
				$uid = '0/2';
			} elseif($row->UID2 == NULL AND $row->UID != NULL){
				$uid = '1/2';
			} elseif($row->UID == NULL AND $row->UID2 != NULL){
				$uid = '1/2';
			} else{
				$uid = '2/2';
			}
		}
		
		$UserData = $row->EndDate;
		$PauseData = $row->pausedate;
		
		$Hoje = strtotime(date("Y-m-d H:i:s"));
		$Venc = strtotime($row->EndDate);

		$Dias = 0;
		$Horas = 0;
		$Minutos = 0;
		$Segundos = 0;
		if($Venc > $Hoje){
			$dteHoje = date("Y-m-d H:i:s");
			$dteStartS = new DateTime($UserData);
			$dteEndS   = new DateTime($dteHoje);
			$CalcD = $dteStartS->diff($dteEndS);
			
			$Dias = $CalcD->format("%a");
			$Horas = $CalcD->format("%H");
			$Minutos = $CalcD->format("%I");
			$Segundos = $CalcD->format("%S");
		}else{
			$Dias = 0;
			$Horas = 0;
			$Minutos = 0;
			$Segundos = 0;
		}
		
		$DiasPsd = 0;
		$HorasPsd = 0;
		$MinutosPsd = 0;
		$SegundosPsd = 0;
		if($row->pause){
			$dteHojePsd = $PauseData;
			$dteStartSPsd = new DateTime($UserData);
			$dteEndSPsd   = new DateTime($PauseData);
			$CalcDPsd = $dteStartSPsd->diff($dteEndSPsd);
			
			$DiasPsd = $CalcDPsd->format("%a");
			$HorasPsd = $CalcDPsd->format("%H");
			$MinutosPsd = $CalcDPsd->format("%I");
			$SegundosPsd = $CalcDPsd->format("%S");
		}
		
		$Mod = $row->mode;
		$usuarios[] = array(
			'id' => $row->id,
			'user' => $row->Username,
			'cargo' => $row->cargo,
			'mode' => $row->mode,
			'data' => $row->StartDate,
			'datafinal' => $row->EndDate,
			'dteV' => $UserData,
			'dias' => $Dias,
			'horas' => $Horas,
			'minutos' => $Minutos,
			'segundos' => $Segundos,
			'diasP' => $DiasPsd,
			'horasP' => $HorasPsd,
			'minutosP' => $MinutosPsd,
			'segundosP' => $SegundosPsd,
			'status' => $row->ban,
			'pause' => $row->pause,
		);
	}
	
// PAUSAR CONTA
if (isset($_GET['pause'])) {
    $pauseX = intval($_GET['pause']); // Garantindo que pauseX seja um inteiro
    $dateHoje = date("Y-m-d H:i:s");
    
    $Hojes = strtotime($dateHoje);
    $Vencs = strtotime($UserData);
    
    if ($pauseX == 1) { // Para pausar
        if ($Vencs > $Hojes) {
            $stdel = $game_db->prepare("UPDATE tokens SET pause = '1', pausedate=? WHERE Username=?");
            $stdel->bindParam(1, $dateHoje);
            $stdel->bindParam(2, $UserEdit);
            if ($stdel->execute()) {
                $auth->AddLog("Pausou usuário", $auth->getLogin(), $UserEdit, $dateHoje, "Nenhuma");
                $success[] = 'Usuário pausado com sucesso.';
                header("Refresh:2; url=index.php?act=editar&name=" . $UserEdit, true, 303);
                exit; // Para garantir que não continue executando
            }
        } else {
            $error[] = 'Conta expirada, não foi possível executar esta ação.';
        }
    } elseif ($pauseX == 2) { // Para despausar
        // Verifica se o usuário existe e se precisa reset
        $sql = "SELECT * FROM tokens WHERE Username = ? AND pause != '0'";
        $stm = $game_db->prepare($sql);
        $stm->bindValue(1, $UserEdit);
        $stm->execute();
        $retorno = $stm->fetch(PDO::FETCH_OBJ);
        
        if (!$retorno) {
            $error[] = 'O usuário não esta pausado /ou você não tem permissão para despausar!';
        } else {
            // Calcula os dias e o tempo devolvido
            $tempoDevolvido = DevolverTempo($retorno->pausedate);
            $dt_expira = date("Y-m-d H:i:s", strtotime('+' . $tempoDevolvido['dias'] . ' days + ' . $tempoDevolvido['horas'] . ' hours + ' . $tempoDevolvido['minutos'] . ' minutes + ' . $tempoDevolvido['segundos'] . ' seconds', strtotime($retorno->EndDate)));

            $sql = "UPDATE tokens SET EndDate = ?, pause = '0', pausedate = NULL WHERE Username = ?";
            $stm = $game_db->prepare($sql);
            $stm->bindParam(1, $dt_expira);
            $stm->bindParam(2, $UserEdit);
            
            if ($stm->execute()) {
               $logMessage = sprintf("Devolveu %d dias, %d horas, %d minutos e %d segundos", 
                    $tempoDevolvido['dias'], 
                    $tempoDevolvido['horas'], 
                    $tempoDevolvido['minutos'], 
                    $tempoDevolvido['segundos']);
                $auth->AddLog("Despausou usuário", $auth->getLogin(), $UserEdit, $dateHoje, $logMessage);
                
                $success[] = 'Usuário despausado com sucesso. Tempo devolvido: ' . $tempoDevolvido['dias'] . ' dias, ' . $tempoDevolvido['horas'] . ' horas, ' . $tempoDevolvido['minutos'] . ' minutos, ' . $tempoDevolvido['segundos'] . ' segundos.';
                header("Refresh:2; url=index.php?act=editar&name=" . $UserEdit, true, 303);
                exit; // Para garantir que não continue executando
            } else {
                $error[] = 'Erro desconhecido, tente novamente mais tarde!';
            }
        }
    } else {
        $error[] = 'Opção inválida, não foi possível executar esta ação.';
    }
}


	// SUPER ADMIN BANIR USUÁRIO
	if (isset($_GET['banir'])) {
		$banX = GET_String('banir');
		if($banX == 1){
			$stdel = $game_db->prepare("UPDATE tokens SET ban = '1' WHERE Username=?");
			$stdel->bindParam(1, $UserEdit);
			if ($stdel->execute()) {
				$dateLog = date("Y-m-d H:i:s");
				$auth->Admin_AddLog("Baniu usuário", $auth->getLogin(), $UserEdit, $dateLog, "Nenhuma");
				$selectBool = true;
			}
		}elseif($banX == 2){
			$stdel = $game_db->prepare("UPDATE tokens SET ban = '0' WHERE Username=?");
			$stdel->bindParam(1, $UserEdit);
			if ($stdel->execute()) {
				$dateLog = date("Y-m-d H:i:s");
				$auth->Admin_AddLog("Desbaniu usuário", $auth->getLogin(), $UserEdit, $dateLog, "Nenhuma");
				$selectBool2 = true;
			}
		}else{
			$selectBoolF = true;
		}
		
		if($selectBool){
			$success[] = 'Usuário banido com sucesso.';
		}
		if($selectBool2){
			$success[] = 'Usuário desbanido com sucesso.';
		}
		if($selectBoolF){
			$error[] = 'Opção inválida, não foi possível executar esta ação.';
		}
	}
	
	if (isset($_GET['change'])){
		$NewName = GET_String('change');
		
		
		if (empty($NewName))
		{
			$error[] = 'Este nome de usuário já existe, tente outro!';
		}
		else
		{
			$length = strlen($NewName);
			if ($length < 4 || $length > 10)
			{
				$error[] = 'O comprimento da nome deve ser de 4 a 10 caracteres!';
			}
			else
			{
				if (!preg_match('|^[A-Z0-9]+$|i', $NewName))
				{
					$error[] = 'Você digitou um nome incorreto! Use apenas números e letras!';
				}
			}
		}
		
		if (count($error) == 0){
		$dbh = $game_db->prepare("SELECT COUNT(*) as number FROM tokens WHERE Username=?");
		$dbh->bindParam(1, $NewName);
		
		$dbh->execute();
		$frow = $dbh->fetchObject();
		
		if($frow->number < 1){
			$dbh1 = $game_db->prepare("UPDATE tokens SET Username=? WHERE Username=?");
			$dbh1->bindParam(1, $NewName);
			$dbh1->bindParam(2, $UserEdit);
			
			if ($dbh1->execute()){
				$dateLog = date("Y-m-d H:i:s");
				$auth->AddLog("Alterou o nome de usuário", $auth->getLogin(), $NewName, $dateLog, "Antigo nome de usuário: ".$UserEdit);
				$success[] = 'Nome de usuário mudado com sucesso.';
				header( "Refresh:2; url=index.php?act=editar&name=".$NewName, true, 303);

				//header('location: index.php?act=editar&name='.$NewName);
			}else{
				$error[] = 'Não foi possível mudar este nome de usuário.';
			}
		}else{
			$error[] = 'Este nome de usuário já existe, tente outro.';
		}
		
		}

	}
	
		if (isset($_GET['changecargo'])){
		$password = GET_String('changecargo');
		
		if (empty($password))
		{
			$error[] = 'Você não digitou a novo cargo!';
		}
		else
		{
			$length = strlen($password);
			if ($length < 5 || $length > 7)
			{
				$error[] = 'O comprimento da senha deve ser de 5 a 7 caracteres!';
			}
			else
			{
				if (!preg_match('|^[A-Z0-9]+$|i', $password))
				{
					$error[] = 'Você digitou uma cargo! Use apenas  letras!';
				}
			}
		}
		
		if (count($error) == 0){
			$dbh1 = $game_db->prepare("UPDATE tokens SET cargo=? WHERE Username=?");
			$dbh1->bindParam(1, $password);
			$dbh1->bindParam(2, $UserEdit);
			
			if ($dbh1->execute()){
				$dateLog = date("Y-m-d H:i:s");
				$auth->AddLog("Alterou a senha do usuário", $auth->getLogin(), $UserEdit, $dateLog, "Nenhuma");
				$success[] = 'cargo alterada com sucesso.';
				header( "Refresh:2; url=index.php?act=editar&name=".$UserEdit, true, 303);
			}else{
				$error[] = 'Não foi possível mudar a senha deste cargo.';
			}
		}
	}
	
	if (isset($_GET['changemodo'])){
		$NovoModo = GET_String('changemodo');
		
		if($NovoModo != 'injetorMobile' && $NovoModo != 'injetorEmulador'){
			$error[] = 'Não foi possível o modo deste usuário.';
		}else{
			$dbh1 = $game_db->prepare("UPDATE tokens SET mode=? WHERE Username=?");
			$dbh1->bindParam(1, $NovoModo);
			$dbh1->bindParam(2, $UserEdit);
			
			if ($dbh1->execute()){
				$dateLog = date("Y-m-d H:i:s");
				$auth->AddLog("Alterou o modo do usuário", $auth->getLogin(), $UserEdit, $dateLog, "Novo modo: ".$NovoModo);
				$success[] = 'Modo alterado com sucesso.';
				header( "Refresh:2; url=index.php?act=editar&name=".$UserEdit, true, 303);
			}else{
				$error[] = 'Não foi possível mudar o modo deste usuário.';
			}
		}
	}
	
if(isset($_POST['adddias'])){
    $endate = POST_Integer('endate'); // Obtém o número de dias para adicionar

    // Converte $UserData para timestamp, garantindo que horas e minutos sejam considerados
    $Hojes = strtotime(date("Y-m-d H:i:s")); // Data e hora atual no formato completo
    $Vencs = strtotime($UserData); // Converte a data de expiração do usuário

    // Se a data de expiração já passou, começa a contar a partir da data atual
    if($Vencs < $Hojes){
        $expira = date('Y-m-d H:i:s', strtotime('+' . $endate . ' days')); // Adiciona dias a partir de agora
    } else {
        // Adiciona os dias à data de expiração existente, mantendo os minutos e segundos
        $expira = date('Y-m-d H:i:s', strtotime($UserData . ' +' . $endate . ' days'));
    }

    if($endate >= 1){
        $dbh = $game_db->prepare("UPDATE tokens SET EndDate=? WHERE Username=?");
        $dbh->bindParam(1, $expira);
        $dbh->bindParam(2, $UserEdit);

        if($dbh->execute()){
            $dateLog = date("Y-m-d H:i:s"); // Registro do log com hora exata
            $auth->Admin_AddLog("Adicionou dias", $auth->getLogin(), $UserEdit, $dateLog, "Quantidade de dias: " . $endate);
            $success[] = 'Foram adicionados com sucesso ' . $endate . ' dias ao usuário';
            header("Refresh:2; url=index.php?act=editar&name=" . $UserEdit, true, 303);
        } else {
            $error[] = 'Não foi possível adicionar dias.';
        }
    } else {
        $error[] = 'Não foi possível adicionar dias, quantidade de dias inválida.';
    }
}


if(isset($_POST['deldias'])){
    $endate = POST_Integer('endate'); // Obtém o número de dias para remover

    // Calcula a nova data de expiração subtraindo os dias
    $expira = date('Y-m-d H:i:s', strtotime($UserData . ' -' . $endate . ' days'));

    $Hojes = strtotime(date("Y-m-d H:i:s")); // Data e hora atual
    $Exps = strtotime($expira); // Nova data de expiração após a remoção

    // Se a nova data de expiração já passou, define como a data atual
    if($Exps < $Hojes){
        $expira = date('Y-m-d H:i:s'); // A data de expiração é agora
    }

    if($endate >= 1){
        $dbh = $game_db->prepare("UPDATE tokens SET EndDate=? WHERE Username=?");
        $dbh->bindParam(1, $expira);
        $dbh->bindParam(2, $UserEdit);

        if($dbh->execute()){
            $dateLog = date("Y-m-d H:i:s"); // Registro do log com hora exata
            $auth->Admin_AddLog("Removeu dias", $auth->getLogin(), $UserEdit, $dateLog, "Quantidade de dias: " . $endate);
            $success[] = 'Foram removidos com sucesso ' . $endate . ' dias do usuário';
            header("Refresh:2; url=index.php?act=editar&name=" . $UserEdit, true, 303);
        } else {
            $error[] = 'Não foi possível remover dias.';
        }
    } else {
        $error[] = 'Não foi possível remover dias, quantidade de dias inválida.';
    }
}

	
	$Main = 'sact';

    if ((!isset($_GET[$Main])) && (!isset($_POST[$Main]))) $sact = 'dashboard';
    else $sact = ((isset($_POST[$Main])) ? $_POST[$Main] : $_GET[$Main]);
    $sact = strtolower(trim(preg_replace('/[^0-9a-z]/i', '', $sact)));

    switch ($sact)
    {
		
		case 'dashboard':
			
			break;
			
		case 'changeuser':

                $smarty->assign('NewPanel', ChangeName($UserEdit));

			break;
			
		case 'changepass':
              
				$smarty->assign('NewPanel', ChangePass($UserEdit));
				break;
				
		case 'changecargo':
              
				$smarty->assign('NewPanel', ChangeCargo($UserEdit));
				break;	
		case 'changemode':
               //if ($auth->getIsAdmin()) {
               $smarty->assign('NewPanel', ChangeMode($UserEdit, $Mod));
               break;
               //}
			
			default:
				break;
	}
}

$breadcrumbs = array(
	array('url' => 'index.php?act=account', 'caption' => 'Dashboard'),
	array('url' => 'index.php?act=users', 'caption' => 'Gerenciar usuários'),
	array('url' => '', 'caption' => 'Editar usuários'),
);

$smarty->assign('pagename', 'Editar usuários');
$smarty->assign('breadcrumbs', $breadcrumbs);
$smarty->assign('active', 'users');
$smarty->assign('usuarios', $usuarios);
$smarty->assign('error', $error);
$smarty->assign('success', $success);
$smarty->display('pages/account/editar.tpl');

?>