<?php

if(!defined('lightengine'))
{
	die('What are you doing here?');
}

if (!$auth->getLoggedIn())
{
	header('location: index.php?act=login');
	return;
}


$sent = isset($_POST['form']);


if ($sent)
{
	
	$email = POST_String('email');

	
	$error = array();

	
	if (empty($email))
	{
		$error[] = 'Você não digitou um endereço de e-mail!';
	}
	else
	{
		
		if (!strcasecmp($email, $auth->getEmail()))
		{
			$error[] = 'Digite um novo endereço de e-mail!';
		}
		else
		{
			
			if (!ValidateEmail($email)) 
			{
				$error[] = 'Você digitou um endereço de e-mail incorreto!';
			}
		}
	}

	
	if (!CheckRecaptcha($config['recaptcha']['private_key']))
	{
		$error[] = 'Confirme que você não é um robô.';
	}

	if (count($error) == 0)
	{
		
		$dbh = $game_db->prepare('SELECT COUNT(id) as email_number FROM account_login WHERE email=?');
		$dbh->bindParam(1, $email);

		
		$dbh->execute();

		
		$row = $dbh->fetchObject();

		
		if ($row->email_number >= $config['registration']['max_email'])
		{
			$error[] = 'Você não pode mais criar contas com o endereço de e-mail especificado!';
		}
	}

	
	if (count($error) == 0)
	{
		
		$id = $auth->getId();

		
		$dbh = $game_db->prepare('UPDATE account_login SET email=? WHERE id=?');
		$dbh->bindParam(1, $email);
		$dbh->bindParam(2, $id);

		
		$dbh->execute();

		
		$auth->setEmail($email);
	}

	$smarty->assign('error', $error);
	
}


$breadcrumbs = array(
	
	array('url' => 'index.php?act=account', 'caption' => 'Dashboard'),
	array('url' => '', 'caption' => 'Mudar E-mail'),
);


$smarty->assign('pagename', 'Mudar E-mail');
$smarty->assign('breadcrumbs', $breadcrumbs);
$smarty->assign('active', 'changemail');
$smarty->assign('recaptcha_key', $config['recaptcha']['public_key']);
$smarty->assign('sent', $sent);
$smarty->assign('email', $auth->getEmail());
$smarty->display('pages/account/changemail.tpl');
?>