<?php
if (!defined('lightengine')) {
    die('What are you doing here?');
}

if (!$auth->getLoggedIn()) {
    header('location: index.php?act=login');
    return;
}

$error = [];
$success = [];

// Carrega versões disponíveis
$versoes_select = array();
$sql = $game_db->query('SELECT versao FROM versoes ORDER BY id DESC');
while ($row = $sql->fetchObject()) {
    $versoes_select[] = $row->versao;
}
$smarty->assign('versoes_select', $versoes_select);

function genUname2() {
    $prefix = "IGRH4X-";
    $seed = str_split("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
    $uname = array();
    $size = 0;
    while ($size != 6) {
        $uname[$size] = $seed[mt_rand(0, count($seed) - 1)];
        $size++;
    }
    return $prefix . implode('', $uname);
}

if (isset($_POST['newuser_form'])) {
    $date = date("Y-m-d H:i:s");
    $login = genUname2();
    $device = $_POST['device'] ?? '';
    $mode = $_POST['modo'] ?? '';
    $daysSelected = (int) ($_POST['dias'] ?? 0);

    // Validações
    if (empty($mode)) {
        $error[] = 'Selecione um modo válido!';
    }
    if (empty($device) || !in_array($device, ['1', '2', 'ilimitado'])) {
        $error[] = 'Selecione uma opção válida para dispositivos!';
    }
    if ($auth->getIsSeller() && $device !== '1') {
        $error[] = 'Vendedores só podem criar Keys com 1 device!';
    }
    if (!in_array($daysSelected, [5, 10, 30])) {
        $error[] = 'Selecione um período válido!';
    }

    if (count($error) == 0) {
        // Cálculo de créditos (1 crédito por 5 dias)
        $creditos = ceil($daysSelected / 5);
        
        // Ajuste para múltiplos dispositivos
        if ($device == '2') {
            $creditos *= 1.5;
        } elseif ($device == 'ilimitado') {
            $creditos *= 2;
        }
        $creditos = (int) $creditos;

        // Verifica créditos
        $dbh = $game_db->prepare("SELECT credits FROM account_login WHERE name = ?");
        $dbh->bindParam(1, $auth->getLogin());
        $dbh->execute();
        $row = $dbh->fetchObject();
        
        if ($row->credits < $creditos) {
            $error[] = "Créditos insuficientes! Necessários: {$creditos}";
        }

        // Cria a conta
if (count($error) == 0) {
    $expira = "0000-00-00 00:00:00";  // <--- CORREÇÃO AQUI
    
    // Deduz créditos
    $update = $game_db->prepare('UPDATE account_login SET credits = credits - ? WHERE name = ?');
    $update->bindParam(1, $creditos);
    $update->bindParam(2, $auth->getLogin());
    
    if ($update->execute()) {
        // Insere a nova key
        $insert = $game_db->prepare('INSERT INTO tokens 
            (Username, StartDate, EndDate, UID, UID2, UID3, Expiry, Vendedor, mode, cargo, ipclient) 
            VALUES (?, ?, ?, NULL, ?, NULL, ?, ?, ?, ?, NULL)');
        
        $insert->execute([
            $login,
            $date,
            $expira,  // <--- AGORA SERÁ 0000-00-00 00:00:00
            $device,
            $daysSelected,
            $auth->getLogin(),
            $mode,
            'cliente'
        ]);

                // Log e mensagem de sucesso
                $auth->AddLog("Nova key gerada", $auth->getLogin(), $login, $date, "{$mode} - {$daysSelected}dias");
                $success[] = "Key: <strong>{$login}</strong> | Modo: {$mode} | Validade: {$daysSelected} dias | Devices: {$device}";
                
                header('refresh:3;url=index.php?act=users');
            }
        }
    }
}

// Configurações para o template
$breadcrumbs = [
    ['url' => 'index.php?act=account', 'caption' => 'Dashboard'],
    ['url' => '', 'caption' => 'Adicionar Key']
];

$smarty->assign('pagename', 'Adicionar Key');
$smarty->assign('breadcrumbs', $breadcrumbs);
$smarty->assign('active', 'adduser');
$smarty->assign('error', $error);
$smarty->assign('success', $success);
$smarty->display('pages/account/adduser.tpl');