<?php
include_once("conexao.php");

if (strpos($_SERVER['HTTP_USER_AGENT'], 'okhttp') !== false) {
    if (empty($_POST["MMmods"])) {
        die("Key invalida.\n");
    }

    $uid = hash('sha256', $_POST['device_id'] ?? '');
    $nome = mysqli_real_escape_string($conexao, $_POST["MMmods"]);

    $resultado = mysqli_query($conexao, "SELECT * FROM tokens WHERE Username = '$nome' LIMIT 1");

    if (mysqli_num_rows($resultado) > 0) {
        $dados = mysqli_fetch_assoc($resultado);
        
        // Verificação de versão - MODIFICAÇÃO PRINCIPAL
        $user_mode = mysqli_real_escape_string($conexao, trim(strval($dados['mode'])));
        $versao_check = mysqli_query($conexao, "SELECT COUNT(*) as total FROM versoes WHERE versao = '$user_mode'");
        
        if (!$versao_check) {
            die("Erro ao verificar versão: " . mysqli_error($conexao));
        }
        
        $result = mysqli_fetch_assoc($versao_check);
        if ($result['total'] == 0) {
            die("Versão inválida. Sua versão ($user_mode) não é suportada.\n");
        }

        // Verificação se está banido (ban = 1)
        if ($dados['ban'] == 1) {
            die("Acesso negado. Usuário banido. " . $dados['motivo_ban'] . "\n");
        }

        // Verificação do tipo de dispositivo (UID2)
        $device_type = $dados['UID2'] ?? '1';

        if ($device_type === 'ilimitado') {
            // Dispositivo ilimitado - não verifica nada
        } 
        elseif ($device_type === '1') {
            // Verificação para 1 dispositivo
            if (empty($dados['UID'])) {
                mysqli_query($conexao, "UPDATE tokens SET UID = '$uid' WHERE Username = '$nome'");
                $dados['UID'] = $uid;
            } 
            elseif ($dados['UID'] != $uid) {
                die("Acesso negado. Limite de 1 dispositivo atingido.\n");
            }
        } 
        elseif ($device_type === '2') {
            // Verificação para 2 dispositivos
            if (empty($dados['UID'])) {
                // Primeiro dispositivo
                mysqli_query($conexao, "UPDATE tokens SET UID = '$uid' WHERE Username = '$nome'");
                $dados['UID'] = $uid;
            } 
            elseif (empty($dados['UID3'])) {
                // Segundo dispositivo
                if ($dados['UID'] != $uid) {
                    mysqli_query($conexao, "UPDATE tokens SET UID3 = '$uid' WHERE Username = '$nome'");
                    $dados['UID3'] = $uid;
                }
            } 
            else {
                // Verifica se o dispositivo atual é um dos dois registrados
                if ($dados['UID'] != $uid && $dados['UID3'] != $uid) {
                    die("Acesso negado. Limite de 2 dispositivos atingido.\n");
                }
            }
        }

        // Lógica de verificação de data/expiração
        $currentDate = date('Y-m-d H:i:s');
        $endDate = $dados['EndDate'];
        $expiryDays = $dados['Expiry'];

        if (($endDate == '0000-00-00 00:00:00' || $endDate == '') && $expiryDays > 0) {
            $newEndDate = date('Y-m-d H:i:s', strtotime("+$expiryDays days"));
            mysqli_query($conexao, "UPDATE tokens SET EndDate = '$newEndDate' WHERE Username = '$nome'");
            $dados['EndDate'] = $newEndDate;
        } 
        elseif ($endDate != '00-00-0000 00:00:00' && $currentDate > $endDate) {
            die("sua assinatura expirou\n");
        }

        $arr = array(
            'status' => 'sucesso',
            'id' => $dados['id'],
            'Username' => $dados['Username'],
            'Password' => $dados['Password'],
            'StartDate' => $dados['StartDate'],
            'EndDate' => $dados['EndDate'],
            'UID' => $dados['UID'],
            'UID2' => $dados['UID2'],
            'UID3' => $dados['UID3'],
            'Expiry' => $dados['Expiry'],
            'Vendedor' => $dados['Vendedor'],
            'mode' => $dados['mode'],
            'pausedate' => $dados['pausedate'],
            'pause' => $dados['pause'],
            'ban' => $dados['ban'],
            'token' => $dados['token'],
            'cargo' => $dados['cargo'],
            'motivo_ban' => $dados['motivo_ban'],
            'reset_count' => $dados['reset_count'],
            'PaisLogin' => $dados['PaisLogin'],
            'ipclient' => $dados['ipclient'],
            'diasrestantes' => (strtotime($dados['EndDate']) - strtotime($currentDate)) > 0 ? floor((strtotime($dados['EndDate']) - strtotime($currentDate)) / 86400) : 0
        );

        echo json_encode($arr);
    } else {
        die("Key nao registrada\n");
    }
} else {
    header("Location: https://mmmods.com/403.html");
    exit();
}